<?php
/*
 * Plugin Name: Indices API
 * Author: indices-api.com
 * Version: 2.4
 * Description: Official <a href="https://indices-api.com/">indices-api.com</a> plugin.
 * Author URL: https://indices-api.com
*/


class IndicesAPI
{

    function saveOption($name){
        if(isset($_POST[$name])){
            update_option($name, sanitize_text_field($_POST[$name]));
        }
    }

    function saveNumericOption($name){
        if(isset($_POST[$name])){
            update_option($name, sanitize_text_field(abs(intval($_POST[$name]))));
        }
    }

    function saveHTMLOption($name){ 
        if(isset($_POST[$name])){
            update_option($name, wp_kses_post($_POST[$name]));
        }
    }

    function render_settings(){ 
        $saved = 0;
        if(isset($_POST['save'])){
            if (!isset($_POST['thenonce']) || !wp_verify_nonce($_POST['thenonce'])) {
                wp_die("ERROR: Request not valid");
            }
            $this->saveOption('indicesapi_apikey'); 
            $this->saveHTMLOption('indiceapi_500_msg');
            $this->saveHTMLOption('indiceapi_200_msg');
            $this->saveHTMLOption('indiceapi_000_msg');
            $saved = 1;
        }

        $indicesapi_apikey = get_option('indicesapi_apikey'); 
        $indiceapi_200_msg = stripslashes(get_option('indiceapi_200_msg', '{{base}} {{price}}'));
        $indiceapi_500_msg = stripslashes(get_option('indiceapi_500_msg', 'Error: {{error}}'));
        $indiceapi_000_msg = stripslashes(get_option('indiceapi_000_msg', 'Error: no answer')); 
        $indiceapi_error = get_option('indiceapi_error'); 

        require plugin_dir_path(__FILE__). 'templates/settings.php';
    }

    function render_info(){
        require plugin_dir_path(__FILE__). 'templates/info.php';
    }

    function addSettings(){
        add_menu_page('Indices API Settings', 'Indices API', 'administrator', 'indicesapi', [$this, 'render_settings']);
        add_submenu_page('indicesapi', 'Indices API Settings', 'Settings', 'administrator', 'indicesapisettings', [$this, 'render_settings']);
        add_submenu_page('indicesapi', 'Information', 'Shortcodes', 'administrator', 'aboutshortcodemetals', [$this, 'render_info']);
        remove_submenu_page("indicesapi", "indicesapi");
    }

    function render($attributes)
    {
        $key = get_option('indicesapi_apikey');
        $base = isset($attributes["base"]) ? strtoupper($attributes["base"]) : 'USD';
        $symbol = strtoupper($attributes["symbol"]);
        $separator = isset($attributes["separator"]) ? $attributes["separator"] : '.';
        $currency_symbol = isset($attributes["currency-symbol"]) ? $attributes["currency-symbol"] : '$';
        
        $uri = "https://www.indices-api.com/api/latest?access_key=$key&base=$base&symbols=$symbol";
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $uri);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);
        curl_close($curl);

        if (isset($_GET['depurando'])) {
            echo 'URL de petición: ' . print_r($uri, true) . '<br/>';
            echo 'Respuesta: ' . print_r($response, true) . '<br/>';
        }
        
        if (!empty(trim($response))) {
            $json = json_decode($response, true);
            $json = $json["data"];
            if (isset($json['success']) && $json['success'] == true) {
                if (isset($json["rates"][$symbol])) {
                    $priced = $json["rates"][$symbol];

                    $price_round = isset($attributes["price-round"]) ? intval($attributes["price-round"]) : 2;


                    $priced = number_format($priced, $price_round, '.', '');

                    if (isset($attributes["separator"]) && !empty($attributes["separator"])) {
                        $separator = $attributes["separator"];
                        $priced = str_replace('.', $separator, $priced);
                    }

                    return $currency_symbol . $priced;
                } else {
                    return "Error: No se encontró la tasa para el símbolo especificado.";
                }
            } else {
                return "Error: Falló la solicitud a la API.";
            }
        }
        
        return "Error: Respuesta vacía de la API.";
    }

    function __construct()
    {
        add_shortcode('indices_api_price', [$this, 'render']);
        add_action('admin_menu', [$this, 'addSettings']);
    }
}

$tesp = new IndicesAPI();