<h1>Indices API Settings</h1>
        <hr><?php if($saved){ ?>
<div class="notice notice-success">
    <p>Your API was saved, now you can start using Indices API with the shortcodes.</p>
</div>
    <?php } ?>
        <form class="" method="post">
            <?php wp_nonce_field(-1, "thenonce");?>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th>Indices API Key</th>
                        <td>
                            <input type="text" name="indicesapi_apikey" value="<?=get_option('indicesapi_apikey');?>" class="regular-text">
                            <p class="description">API status: <span><?=isset($indicesapi_error) && trim($indicesapi_error) !="" ? $indicesapi_error : "Not used yet";?></span></p>
                            <p class="description">You can get your API key by registering at <a href="https://Indices-api.com/#pricing" target="_blank">Indices API</a>. After you sign in up, please copy " Your API Access Key" on the dashboard section.</p>
                        </td>
                    </tr>
                </tbody>
            </table>
            <h3>Shortcode templates</h3>
            <p>Use the below controls to print your desired content in the short code. API can return with success, failure or no data. So please fill up your desired data for thrice cases. You can also use the provided codes below to display dynamic content.</p>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th><span class="success">Success Fetching</span></th>
                        <td>
                            <?php wp_editor( 
                                        stripslashes ( get_option("indicesapi_200_msg" ,'{{currency}} {{price}}') ), 
                                        "indicesapi_200_msg", 
                                        array( 
                                            "textarea_name" =>"indicesapi_200_msg",
                                            "textarea_rows" => 4
                                        )
                                ); 
                            ?>
                            <p class="description">You can use {{base}}, {{timestamp}}, {{price}}, {{symbol}}, {{unit}}, {{date}} in above textarea</p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th><span class="error">Error Result</span></th>
                        <td>
                            <?php wp_editor( 
                                        stripslashes( get_option("indicesapi_500_msg",'Error: {{error}}') ), 
                                        "indicesapi_500_msg", 
                                        array( 
                                            "textarea_name" =>"indicesapi_500_msg",
                                            "textarea_rows" =>  4
                                        )
                                ); 
                            ?>
                            <p class="description">You can use {{error}} to display API error to user</p>
                        </td>
                    </tr>
                    
                    <tr>
                        <th><span class="empty">Message when no answer is received</span></th>
                        <td>
                            <?php wp_editor( 
                                        stripslashes( get_option("indicesapi_000_msg",'Error: no answer') ), 
                                        "indicesapi_000_msg", 
                                        array( 
                                            "textarea_name" =>"indicesapi_000_msg",
                                            "textarea_rows" =>4
                                        )
                                ); 
                            ?>
                        </td>
                    </tr>
                    
                </tbody>
            </table>
            <p>
                <button type="submit" class="button button-primary" name="save">Submit</button>
            </p>
        </form> 